// ===================
// Sidebar Active Menu Highlight
// ===================
document.addEventListener("DOMContentLoaded", async () => {
const currentPage = window.location.pathname.split("/").pop().toLowerCase();
const navLinks = document.querySelectorAll('.nav-list .nav-link');
navLinks.forEach(link => {
  const linkPage = link.getAttribute('href').toLowerCase();
  if (
    linkPage === currentPage ||
    (currentPage === "addclient.html" && linkPage === "clients.html")
  ) {
    link.classList.add('active');
  } else {
    link.classList.remove('active');
  }
});

// Cancel Button → Go back to Clients.html
const cancelBtn = document.getElementById("cancelBtn");
if (cancelBtn) {
  cancelBtn.addEventListener("click", () => {
    window.location.href = "Clients.html";
  });
}

const profileLogo = document.querySelector(".dashboard-head img");
  if (profileLogo) {
    profileLogo.addEventListener("click", () => {
      window.location.href = "profile.html";
    });
  }

  // Sidebar Toggle
  const sidebar = document.getElementById("sidebar");
  const toggleBtn = document.getElementById("sidebarToggle");
  if (toggleBtn) {
    toggleBtn.addEventListener("click", function () {
      sidebar.classList.toggle("active");
    });
  }

  const form = document.querySelector("form");
  const editClientId = localStorage.getItem("editClientId");

  if (editClientId) {
    // Editing existing client
    try {
      const res = await fetch(`http://127.0.0.1:8000/api/clients/${editClientId}/`);
      if (!res.ok) throw new Error("Failed to fetch client");
      const client = await res.json();

      // Prefill form
      document.getElementById("companyName").value = client.company_name || "";
      document.getElementById("industry").value = client.industry || "";
      document.getElementById("personName").value = client.person_name || "";
      document.getElementById("Contact").value = client.contact_number || "";
      document.getElementById("Email").value = client.email || "";
      document.getElementById("Website").value = client.website || "";
      document.getElementById("Address").value = client.address || "";
      document.getElementById("GST").value = client.gst || "";
      document.getElementById("AMC").value = client.amc || "";
      document.getElementById("AMCPrice").value = client.amc_price || "";
      document.getElementById("Domain").value = client.domain_name || "";
      document.getElementById("DomainCharges").value = client.domain_charges || "";
      document.getElementById("ServerDetails").value = client.server_details || "";
      document.getElementById("ServerPrice").value = client.server_price || "";
      document.getElementById("MaintenanceValue").value = client.maintenance_value || "";
      document.getElementById("Comments").value = client.comments || "";
      document.getElementById("Domainstdate").value = client.domain_start_date || "";
      document.getElementById("Domainendate").value = client.domain_end_date || "";
      document.getElementById("Serverstdate").value = client.server_start_date || "";
      document.getElementById("Serverendate").value = client.server_end_date || "";
      document.getElementById("Maintenancestartdate").value = client.maintenance_start_date || "";
      document.getElementById("MaintenanceEnddate").value = client.maintenance_end_date || "";
      document.getElementById("Priority").value = client.priority || "";
      document.getElementById("Status").value = client.status || "";
      document.querySelector("h1.dashboard").innerText = "Edit Client";
      document.querySelector(".custom-btn1").innerText = "Update";

      // Submit → PUT update
      form.addEventListener("submit", async (e) => {
        e.preventDefault();
        const data = getFormData();

        try {
          const response = await fetch(`http://127.0.0.1:8000/api/clients/${editClientId}/`, {
            method: "PUT",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify(data),
          });

          if (response.ok) {
            alert("Client updated successfully!");
            localStorage.removeItem("editClientId");
            window.location.href = "Clients.html";
          } else {
            alert("Error updating client.");
          }
        } catch (err) {
          console.error(err);
          alert("Server error.");
        }
      });
    } catch (err) {
      console.error(err);
      alert("Error loading client data.");
    }
  } else {
    // Adding new client
    form.addEventListener("submit", async (e) => {
      e.preventDefault();
      const data = getFormData();

      try {
        const response = await fetch("http://127.0.0.1:8000/api/clients/", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify(data),
        });

        if (response.ok) {
          alert("Client saved successfully!");
          window.location.href = "Clients.html";
        } else {
          alert("Error saving client.");
        }
      } catch (err) {
        console.error(err);
        alert("Server error.");
      }
    });
  }

  function getFormData() {
    return {
      company_name: document.getElementById("companyName").value,
      industry: document.getElementById("industry").value,
      person_name: document.getElementById("personName").value,
      contact_number: document.getElementById("Contact").value,
      email: document.getElementById("Email").value,
      website: document.getElementById("Website").value,
      address: document.getElementById("Address").value,
      gst: document.getElementById("GST").value,
      amc: document.getElementById("AMC").value,
      amc_price: document.getElementById("AMCPrice").value,
      domain_name: document.getElementById("Domain").value,
      domain_charges: document.getElementById("DomainCharges").value,
      domain_start_date: document.getElementById("Domainstdate").value,
      domain_end_date: document.getElementById("Domainendate").value,
      server_details: document.getElementById("ServerDetails").value,
      server_price: document.getElementById("ServerPrice").value,
      server_start_date: document.getElementById("Serverstdate").value,
      server_end_date: document.getElementById("Serverendate").value,
      maintenance_value: document.getElementById("MaintenanceValue").value,
      maintenance_start_date: document.getElementById("Maintenancestartdate").value,
      maintenance_end_date: document.getElementById("MaintenanceEnddate").value,
      comments: document.getElementById("Comments").value,
      priority: document.getElementById("Priority").value,
      status: document.getElementById("Status").value,
    };
  }
});
