import os, sys

# --- Path setup ---
project_home = '/home/designbharat/public_html/crm.design-bharat.com'
venv_path = os.path.join(project_home, 'venv')

# Add project and app to Python path
sys.path.insert(0, os.path.join(project_home, 'crm_backend'))
sys.path.insert(0, project_home)

# Activate virtual environment
activate_this = os.path.join(venv_path, 'bin', 'activate_this.py')
if os.path.exists(activate_this):
    with open(activate_this) as f:
        exec(f.read(), {'__file__': activate_this})

# Django settings
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'crm_backend.settings')

# Ensure correct Python interpreter
INTERP = os.path.join(venv_path, 'bin', 'python3')
if sys.executable != INTERP:
    os.execl(INTERP, INTERP, *sys.argv)

# Load application
from django.core.wsgi import get_wsgi_application
application = get_wsgi_application()
