// ===========================
// Add / Edit Updation 
// ===========================
document.addEventListener("DOMContentLoaded", async () => {
  const form = document.getElementById("updationForm");
  const editId = localStorage.getItem("editUpdationId");
  const token = localStorage.getItem("authToken");

  // Redirect if not logged in
  if (!token) {
    alert("Session expired. Please log in again.");
    window.location.href = "/";
    return;
  }

  // -----------------------
  // Cancel Button
  // -----------------------
  const cancelBtn = document.getElementById("cancelBtn");
  if (cancelBtn){
    cancelBtn.addEventListener("click", () => {
      window.location.href = "/updation";
    });
  }
    
    // Profile logo redirect
  const profileLogo = document.querySelector(".dashboard-head img");
  if (profileLogo) {
    profileLogo.addEventListener("click", () => {
      window.location.href = "/user-profile/";
    });
  }
  
  
  // -----------------------
  // Sidebar + Profile
  // -----------------------
  const sidebar = document.getElementById("sidebar");
  const toggleBtn = document.getElementById("sidebarToggle");
  if (toggleBtn) toggleBtn.addEventListener("click", () => sidebar.classList.toggle("active"));


  
 // Sidebar Active Menu Highlight
  const currentPath = window.location.pathname.toLowerCase().replace(/\/$/, "");
  const normalizedCurrent = currentPath.replace(/\.html$/, "");

  document.querySelectorAll(".nav-list .nav-link").forEach(link => {
    const linkHref = link.getAttribute("href").toLowerCase().replace(/\/$/, "");
    const normalizedHref = linkHref.replace(/\.html$/, "");

    if (
      normalizedCurrent === normalizedHref ||
      normalizedCurrent.startsWith(normalizedHref + "/")
    ) {
      link.classList.add("active");
    } else {
      link.classList.remove("active");
    }
  });

  

  

  // -------------------
  // If editing, fetch existing data
  // -------------------
  if (editId) {
    try {
     console.log("Trying to load updations ID:", editId);
      const response  = await fetch(
        `https://crm.design-bharat.com/api/updations/${editId}/`,{
          headers: {
            "Authorization": `Token ${token}`,
            "Content-Type": "application/json",
          },
      });
       console.log("Status:", response.status);

      if (!response.ok) {
        const errText = await response.text();
        console.error("Failed to load updation:", errText);
        alert(`Failed to load updation details. Please try again.(${response.status})`);
        return;
      }

      const updation = await response.json();
      console.log("Loaded updation:", updation);

      // Fill form fields
     document.getElementById("clientName").value = updation.client_name || "";
     document.getElementById("projectName").value = updation.project_name || "";
     document.getElementById("Status").value = updation.status || "";
     document.getElementById("description").value = updation.description || "";

    } catch (err) {
      console.error("Error loading updations:", err);
      alert("Failed to load updations details.");
    }
  }
      
// -----------------------
// Form Submit (Add/Edit)
// -----------------------
form.addEventListener("submit", async (e) => {
  e.preventDefault();

  const data = getFormData();

  try {
      let url = "https://crm.design-bharat.com/api/updations/";
      let method = "POST";

      if (editId) {
        url += `${editId}/`;
        method = "PUT";
      }

  const response = await fetch(url, {
        method: method,
        headers: {
          "Content-Type": "application/json",
          "Authorization": `Token ${token}`,
        },
        body: JSON.stringify(data),
      });
      
       if (response.ok) {
        alert(editId ? "Updations updated successfully!" : "Updation saved successfully!");
        localStorage.removeItem("editUpdationId");
        window.location.href = "/updation";
      } else {
        const errorText = await response.text();
        console.error("API Error:", errorText);
        alert("Error saving updation. Please check console for details.");
      }
    } catch (err) {
      console.error(err);
      alert("Server error. Please try again later.");
    }
  });

    // -------------------
  // Collect form data
  // -------------------
  function getFormData() {
    const today = new Date().toISOString().split("T")[0];
    return {
      client_name: document.getElementById("clientName").value,
       project_name: document.getElementById("projectName").value,
      status: document.getElementById("Status").value.trim(),
      description: document.getElementById("description").value.trim(),
      date: today
    };
  }
}); 


